(function($){
  function getVal(name){
    var $el = $('*[name="'+name+'"]');
    return $el.length ? $el.val() : '';
  }

  function ensureHeadingTag($preview, desiredTag){
    desiredTag = (desiredTag || 'h2').toLowerCase();
    if(['h2','h3','h4','h5'].indexOf(desiredTag) === -1){ desiredTag = 'h2'; }

    var $h = $preview.find('.wptx-aibd__heading');
    if(!$h.length){ return; }
    var currentTag = ($h.prop('tagName') || '').toLowerCase();
    if(currentTag === desiredTag){ return; }

    var text = $h.text();
    var $new = $('<'+desiredTag+'/>', { 'class':'wptx-aibd__heading', text: text });
    $h.replaceWith($new);
  }

  function updatePreview(){
    var $preview = $('#wptx-aibd-live-preview');
    if(!$preview.length){ return; }

    var vars = {
      '--wptx-aibd-bg': getVal('wptx_aibd_options_v1[color_bg]'),
      '--wptx-aibd-fg': getVal('wptx_aibd_options_v1[color_text]'),
      '--wptx-aibd-border': getVal('wptx_aibd_options_v1[color_border]'),
      '--wptx-aibd-bg-hover': getVal('wptx_aibd_options_v1[color_bg_hover]'),
      '--wptx-aibd-fg-hover': getVal('wptx_aibd_options_v1[color_text_hover]')
    };

    Object.keys(vars).forEach(function(k){
      if(vars[k] !== undefined && vars[k] !== null && vars[k] !== ''){
        $preview[0].style.setProperty(k, vars[k]);
      }
    });

    var style = getVal('wptx_aibd_options_v1[button_style]') || 'pills';
    $preview.removeClass('wptx-aibd--square wptx-aibd--round wptx-aibd--pills wptx-aibd--outline')
            .addClass('wptx-aibd--' + style);

    var showIcons = $('input[name="wptx_aibd_options_v1[show_icons]"]').is(':checked');
    $preview.toggleClass('wptx-aibd--icons', showIcons);
    $preview.find('.wptx-aibd__icon').css('display', showIcons ? '' : 'none');

    var headingEnabled = $('input[name="wptx_aibd_options_v1[heading_enabled]"]').is(':checked');
    var headingText = $('input[name="wptx_aibd_options_v1[heading_text]"]').val() || '';
    var headingTag = getVal('wptx_aibd_options_v1[heading_tag]') || 'h2';

    var $h = $preview.find('.wptx-aibd__heading');
    if(headingEnabled){
      if(!$h.length){
        $preview.prepend('<h2 class="wptx-aibd__heading"></h2>');
        $h = $preview.find('.wptx-aibd__heading');
      }
      $h.text(headingText).show();
      ensureHeadingTag($preview, headingTag);
    }else{
      $h.hide();
    }

    ['chatgpt','perplexity','grok','googleai','claude','gemini'].forEach(function(k){
      var enabled = $('input[name="wptx_aibd_options_v1[enabled_providers][]"][value="'+k+'"]').is(':checked');
      $preview.find('.wptx-aibd__btn--'+k).css('display', enabled ? '' : 'none');
    });

    var copyEnabled = $('input[name="wptx_aibd_options_v1[show_copy]"]').is(':checked');
    var copyLabel = $('input[name="wptx_aibd_options_v1[copy_label]"]').val() || 'Copy prompt';
    var $copy = $preview.find('.wptx-aibd__btn--copy');
    if(copyEnabled){
      $copy.find('.wptx-aibd__label').text(copyLabel);
      $copy.show();
    }else{
      $copy.hide();
    }
  }

  function scheduleUpdate(){
    if(window.requestAnimationFrame){
      window.requestAnimationFrame(updatePreview);
    }else{
      updatePreview();
    }
    setTimeout(updatePreview, 80);
  }

  $(function(){
    $('.wptx-aibd-color').wpColorPicker({
      change: function(event, ui){
        if(ui && ui.color && ui.color.toString){
          $(event.target).val(ui.color.toString());
        }
        scheduleUpdate();
      },
      clear: function(){ scheduleUpdate(); }
    });

    $(document).on('input change', '.wptx-aibd-color', scheduleUpdate);

    $(document).on('input change',
      'select[name="wptx_aibd_options_v1[button_style]"], '+
      'select[name="wptx_aibd_options_v1[heading_tag]"], '+
      'input[name="wptx_aibd_options_v1[heading_text]"], '+
      'input[name="wptx_aibd_options_v1[copy_label]"]',
      scheduleUpdate
    );

    $(document).on('change',
      'input[name="wptx_aibd_options_v1[heading_enabled]"], '+
      'input[name="wptx_aibd_options_v1[show_copy]"], '+
      'input[name="wptx_aibd_options_v1[show_icons]"], '+
      'input[name="wptx_aibd_options_v1[enabled_providers][]"]',
      scheduleUpdate
    );


    $(document).on('change', '#wptx-aibd-reset-confirm', function(){
      var ok = $(this).is(':checked');
      $('#wptx-aibd-reset-btn').prop('disabled', !ok);
    });

    scheduleUpdate();
  });
})(jQuery);
