(function(wp){
  if (!wp || !wp.blocks || !wp.element || !wp.i18n || !wp.blockEditor || !wp.components) {
    return;
  }

  var el = wp.element.createElement;
  var __ = wp.i18n.__;
  var InspectorControls = wp.blockEditor.InspectorControls;
  var useBlockProps = wp.blockEditor.useBlockProps;
  var PanelBody = wp.components.PanelBody;
  var ToggleControl = wp.components.ToggleControl;
  var CheckboxControl = wp.components.CheckboxControl;
  var TextControl = wp.components.TextControl;
  var TextareaControl = wp.components.TextareaControl;
  var PROVIDERS = [
    { key:'chatgpt', label:'ChatGPT' },
    { key:'perplexity', label:'Perplexity' },
    { key:'grok', label:'Grok' },
    { key:'googleai', label:'Google AI' },
    { key:'claude', label:'Claude' },
    { key:'gemini', label:'Gemini' }
  ];

  wp.blocks.registerBlockType('wptechs/ai-button-dock', {
    edit: function(props){
      var attrs = props.attributes || {};
      var setAttributes = props.setAttributes;

      var useGlobal = attrs.useGlobal !== false;
      var providers = Array.isArray(attrs.providers) ? attrs.providers : [];
      var heading = typeof attrs.heading === 'string' ? attrs.heading : '';
      var promptBefore = typeof attrs.promptBefore === 'string' ? attrs.promptBefore : '';
      var promptAfter  = typeof attrs.promptAfter === 'string' ? attrs.promptAfter : '';
      var includeTitle = attrs.includeTitle !== false;

      function toggleProvider(key, enabled){
        var next = providers.slice();
        var has = next.indexOf(key) !== -1;
        if(enabled && !has){ next.push(key); }
        if(!enabled && has){ next = next.filter(function(k){ return k !== key; }); }
        setAttributes({ providers: next });
      }

      var inspector = el(InspectorControls, {},
        el(PanelBody, { title: __('AI Share Buttons', 'wptechs-ai-share-buttons'), initialOpen: true },
          el(ToggleControl, {
            label: __('Use global settings', 'wptechs-ai-share-buttons'),
            checked: useGlobal,
            onChange: function(v){ setAttributes({ useGlobal: !!v }); }
          }),
          !useGlobal ? el('div', {},
            el(TextControl, {
              label: __('Heading override (optional)', 'wptechs-ai-share-buttons'),
              value: heading,
              onChange: function(v){ setAttributes({ heading: v }); }
            }),
            el(TextareaControl, {
              label: __('Prompt before URL (optional)', 'wptechs-ai-share-buttons'),
              value: promptBefore,
              rows: 3,
              onChange: function(v){ setAttributes({ promptBefore: v }); }
            }),
            el(TextareaControl, {
              label: __('Prompt after URL (optional)', 'wptechs-ai-share-buttons'),
              value: promptAfter,
              rows: 3,
              onChange: function(v){ setAttributes({ promptAfter: v }); }
            }),
            el(ToggleControl, {
              label: __('Append post title', 'wptechs-ai-share-buttons'),
              checked: includeTitle,
              onChange: function(v){ setAttributes({ includeTitle: !!v }); }
            }),
            el('div', { style:{ marginTop:'8px' } },
              PROVIDERS.map(function(p){
                return el(CheckboxControl, {
                  key: p.key,
                  label: p.label,
                  checked: providers.indexOf(p.key) !== -1,
                  onChange: function(v){ toggleProvider(p.key, v); }
                });
              })
            )
          ) : null
        )
      );

      var preview = el('div', { style:{ padding:'12px', border:'1px solid #ddd', borderRadius:'12px', cursor:'pointer', background:'#fff' } },
        el('div', { style:{ fontWeight:700, marginBottom:'6px' } }, __('AI Share Buttons', 'wptechs-ai-share-buttons')),
        el('div', { style:{ opacity:0.8, marginBottom:'10px' } }, useGlobal ? __('Using global plugin settings.', 'wptechs-ai-share-buttons') : __('Using block overrides.', 'wptechs-ai-share-buttons')),
        el('div', { style:{ display:'flex', gap:'8px', flexWrap:'wrap' } },
          PROVIDERS.map(function(p){
            return el('span', { key:p.key, style:{ padding:'6px 10px', border:'1px solid #ccc', borderRadius:'999px' } }, p.label);
          })
        )
      );

      var blockProps = useBlockProps({ className: 'wptx-aibd-block-preview' });
      return el('div', blockProps, inspector, preview);
    },
    save: function(){ return null; }
  });
})(window.wp);