(function () {
  function copyText(text) {
    if (!text) { return Promise.reject(); }
    if (navigator.clipboard && navigator.clipboard.writeText) {
      return navigator.clipboard.writeText(text);
    }
    var ta = document.createElement('textarea');
    ta.value = text;
    ta.setAttribute('readonly', '');
    ta.style.position = 'absolute';
    ta.style.left = '-9999px';
    document.body.appendChild(ta);
    ta.focus();
    ta.select();
    try {
      document.execCommand('copy');
      document.body.removeChild(ta);
      return Promise.resolve();
    } catch (e) {
      document.body.removeChild(ta);
      return Promise.reject(e);
    }
  }

  function closest(el, selector) {
    if (!el) return null;
    if (el.closest) return el.closest(selector);
    while (el && el.nodeType === 1) {
      if (el.matches && el.matches(selector)) return el;
      el = el.parentElement;
    }
    return null;
  }

  function openUrl(url, newTab) {
    if (!url) return;
    if (newTab) {
      window.open(url, '_blank', 'noopener,noreferrer');
    } else {
      window.location.href = url;
    }
  }

  document.addEventListener('click', function (e) {
    var copyBtn = closest(e.target, '[data-wptx-aibd-copy="1"]');
    if (copyBtn) {
      e.preventDefault();

      var prompt = copyBtn.getAttribute('data-wptx-aibd-prompt') || '';
      var labelEl = copyBtn.querySelector('.wptx-aibd__label');
      var original = labelEl ? labelEl.textContent : copyBtn.textContent;

      copyText(prompt).then(function () {
        var ok = (window.WPTX_AIBD && WPTX_AIBD.copyOk) ? WPTX_AIBD.copyOk : 'Copied!';
        if (labelEl) labelEl.textContent = ok;
        else copyBtn.textContent = ok;

        setTimeout(function () {
          if (labelEl) labelEl.textContent = original;
          else copyBtn.textContent = original;
        }, 1200);
      }).catch(function () {
        alert((window.WPTX_AIBD && WPTX_AIBD.copyFail) ? WPTX_AIBD.copyFail : 'Copy failed. Please copy manually.');
      });

      return;
    }

    var openBtn = closest(e.target, '[data-wptx-aibd-href]');
    if (openBtn) {
      e.preventDefault();

      var url = openBtn.getAttribute('data-wptx-aibd-href') || '';
      var newTab = (openBtn.getAttribute('data-wptx-aibd-newtab') === '1');

      openUrl(url, newTab);
      return;
    }
  }, false);
})();